// PCW99_ODBC_Generic.cpp : Defines the initialization routines for the DLL.

#include "stdafx.h"
#include "PCW99_ODBC_Generic.h"
#include "PCW99_ODBC_Generic_OLTP_Read_Select.h"
#include "PCW99_ODBC_Generic_OLTP_Read_Join.h"
#include "PCW99_ODBC_Generic_OLTP_Write.h"
#include "PCW99_ODBC_Generic_DSS_Select.h"

IMPLEMENT_SERIAL(PCW99_ODBC_Generic,CSSBenchmark,1)

/******************************************************************************
*
*
*  FUNCTION: GetBenchmarkClassInfo
*
*
******************************************************************************/

extern "C" BOOL AFX_EXT_API GetBenchmarkClassInfo (CSSBenchmark **pCSSBenchmark)
{
	*pCSSBenchmark = (CSSBenchmark *) new PCW99_ODBC_Generic();

	return TRUE;
}

/******************************************************************************
*
*
*  CLASS: PCW99_ODBC_Generic
*
*	PC Week Desktop Database Benchmark 1999 implementation
*   -- generic ODBC version
*
*	written by Timothy Dyck, timothy_dyck@zd.com
*
*
******************************************************************************/

PCW99_ODBC_Generic::PCW99_ODBC_Generic ()
{

	// Initialize Benchmark description values
	m_nBenchmarkID		= 1001;
	m_nVendorID			= ODBC_DRIVER;
	m_szBenchmarkName	= "PCW99";
	m_szComment		= "PC Week SQL Database Server Benchmark";
	SetBenchmarkVersion (2,7);			// version 2.7
	m_szDescription = "generic ODBC version";

	// Add transaction groupings
	AddXactGroup (OLTPReadSelect,"OLTP Read - Selects");
	AddXactGroup (OLTPReadJoin,"OLTP Read - Joins");
	AddXactGroup (OLTPWrite,"OLTP Writes");
	AddXactGroup (DSSSelect,"DSS Selects");

	// ==================================================

	// Create Dedicated Reporting Test (single user version)
	CSingleUserBenchmarkInfo *pDedicated_Reporting_Test_Benchmark_SU = CreatePredefinedSingleUserBenchmark("Dedicated Reporting Test");
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+01);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+02);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+03);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+04);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+05);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+06);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+07);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+8);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+9);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+10);
	pDedicated_Reporting_Test_Benchmark_SU->AddXact (XID_DSS_SELECT+11);
	// Register benchmark
	AddPredefinedSingleUserBenchmark (pDedicated_Reporting_Test_Benchmark_SU);

	// Create OLTP Single Read Test (multiuser version)
	CMultiUserTestInfo *pOLTP_Single_Read_Test_MU;
	pOLTP_Single_Read_Test_MU = CreatePredefinedMultiUserTest ("OLTP Single Read Test");
	// Add transactions
	pOLTP_Single_Read_Test_MU->AddXact(XID_OLTP_READ_SELECT+01,1000);
	// Create OLTP Single Read Test benchmark (multiuser version)
	CMultiUserBenchmarkInfo *pOLTP_Single_Read_Test_Benchmark_MU;
	pOLTP_Single_Read_Test_Benchmark_MU = CreatePredefinedMultiUserBenchmark("OLTP Single Read Test Benchmark");
	// Register benchmark
	pOLTP_Single_Read_Test_Benchmark_MU->AddMultiUserTest (pOLTP_Single_Read_Test_MU);
	AddPredefinedMultiUserBenchmark (pOLTP_Single_Read_Test_Benchmark_MU);

#if (_EXTRA_MIXES_ == TRUE)
	// Create OLTP Read Mix Test benchmark (multiuser version)
	CMultiUserTestInfo *pOLTP_Read_Mix_Test_MU;
	pOLTP_Read_Mix_Test_MU = CreatePredefinedMultiUserTest ("OLTP Read Mix Test");
	// Add transactions
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+01,410);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+02,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+03,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+04,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+05,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+06,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+07,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+8,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+9,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+10,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+11,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+12,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+13,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+14,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+15,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+16,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+17,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+18,10);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+01,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+02,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+03,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+04,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+05,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+06,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+07,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+8,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+9,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+10,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+11,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+12,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+13,30);
	pOLTP_Read_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+14,30);
	// Create Mixed Workload Test benchmark (multiuser version)
	CMultiUserBenchmarkInfo *pOLTP_Read_Mix_Test_Benchmark_MU;
	pOLTP_Read_Mix_Test_Benchmark_MU = CreatePredefinedMultiUserBenchmark("OLTP Read Mix Test Benchmark");
	// Register benchmark
	pOLTP_Read_Mix_Test_Benchmark_MU->AddMultiUserTest (pOLTP_Read_Mix_Test_MU);
	AddPredefinedMultiUserBenchmark (pOLTP_Read_Mix_Test_Benchmark_MU);

	// Create OLTP Write_Mix Test benchmark (multiuser version)
	CMultiUserTestInfo *pOLTP_Write_Mix_Test_MU;
	pOLTP_Write_Mix_Test_MU = CreatePredefinedMultiUserTest ("OLTP Write Mix Test");
	// Add transactions
	pOLTP_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+01,200);
	pOLTP_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+02,200);
	pOLTP_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+03,200);
	pOLTP_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+04,200);
	pOLTP_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+05,200);
	// Create OLTP Write_Mix Mix Test benchmark (multiuser version)
	CMultiUserBenchmarkInfo *pOLTP_Write_Mix_Mix_Test_Benchmark_MU;
	pOLTP_Write_Mix_Mix_Test_Benchmark_MU = CreatePredefinedMultiUserBenchmark("OLTP Write Mix Test Benchmark");
	// Register benchmark
	pOLTP_Write_Mix_Mix_Test_Benchmark_MU->AddMultiUserTest (pOLTP_Write_Mix_Test_MU);
	AddPredefinedMultiUserBenchmark (pOLTP_Write_Mix_Mix_Test_Benchmark_MU);
#endif

	// Create OLTP Read/Write Mix Test benchmark (multiuser version)
	CMultiUserTestInfo *pOLTP_Read_Write_Mix_Test_MU;
	pOLTP_Read_Write_Mix_Test_MU = CreatePredefinedMultiUserTest ("OLTP Read/Write Mix Test");
	// Add transactions
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+01,210);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+02,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+03,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+04,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+05,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+06,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+07,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+8,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+9,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+10,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+11,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+12,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+13,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+14,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+15,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+16,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+17,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_SELECT+18,10);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+01,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+02,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+03,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+04,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+05,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+06,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+07,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+8,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+9,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+10,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+11,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+12,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+13,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_READ_JOIN+14,30);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+01,40);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+02,40);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+03,40);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+04,40);
	pOLTP_Read_Write_Mix_Test_MU->AddXact(XID_OLTP_WRITE+05,40);
	// Create OLTP Read/Write Mix Test benchmark (multiuser version)
	CMultiUserBenchmarkInfo *pOLTP_Read_Write_Mix_Test_Benchmark_MU;
	pOLTP_Read_Write_Mix_Test_Benchmark_MU = CreatePredefinedMultiUserBenchmark("OLTP Read/Write Mix Test Benchmark");
	// Register benchmark
	pOLTP_Read_Write_Mix_Test_Benchmark_MU->AddMultiUserTest (pOLTP_Read_Write_Mix_Test_MU);
	AddPredefinedMultiUserBenchmark (pOLTP_Read_Write_Mix_Test_Benchmark_MU);

	// Create Mixed Workload Test benchmark (multiuser version)
	CMultiUserTestInfo *pMixed_Workload_Test_MU;
	pMixed_Workload_Test_MU = CreatePredefinedMultiUserTest ("Mixed Workload Test");
	// Add transactions
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+01,160);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+02,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+03,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+04,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+05,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+06,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+07,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+8,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+9,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+10,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+11,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+12,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+13,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+14,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+15,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+16,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+17,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_SELECT+18,10);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+01,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+02,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+03,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+04,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+05,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+06,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+07,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+8,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+9,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+10,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+11,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+12,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+13,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_READ_JOIN+14,30);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_WRITE+01,40);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_WRITE+02,40);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_WRITE+03,40);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_WRITE+04,40);
	pMixed_Workload_Test_MU->AddXact(XID_OLTP_WRITE+05,40);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+01,10);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+02,10);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+03,2);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+04,2);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+05,2);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+06,1);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+07,1);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+8,1);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+9,1);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+10,10);
	pMixed_Workload_Test_MU->AddXact(XID_DSS_SELECT+11,10);
	// Create Mixed Workload Test benchmark (multiuser version)
	CMultiUserBenchmarkInfo *pMixed_Workload_Test_Benchmark_MU;
	pMixed_Workload_Test_Benchmark_MU = CreatePredefinedMultiUserBenchmark("Mixed Workload Test Benchmark");
	// Register benchmark
	pMixed_Workload_Test_Benchmark_MU->AddMultiUserTest (pMixed_Workload_Test_MU);
	AddPredefinedMultiUserBenchmark (pMixed_Workload_Test_Benchmark_MU);

}

PCW99_ODBC_Generic::~PCW99_ODBC_Generic ()
{
}

// register individual transactions
BOOL PCW99_ODBC_Generic::RegisterTransactions (BOOL bRegisterObjectXact)
{

	// initialize transaction array
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_01);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_02);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_03);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_04);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_05);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_06);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_07);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_08);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_09);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_10);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_11);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_12);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_13);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_14);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_15);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_16);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_17);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Select_18);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_01);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_02);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_03);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_04);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_05);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_06);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_07);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_08);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_09);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_10);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_11);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_12);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_13);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Read_Join_14);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Write_01);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Write_02);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Write_03);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Write_04);
	m_CXactArray.Add((CXact *) new CXact_OLTP_Write_05);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_01);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_02);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_03);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_04);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_05);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_06);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_07);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_08);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_09);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_10);
	m_CXactArray.Add((CXact *) new CXact_DSS_Select_11);

	if (bRegisterObjectXact) {
		// run SQL scripts manually to setup database
	}

	return TRUE;

}
